/*
	Menus.c -- Version 3.0
	
	Developer Technical Support Apple II Sample Code
	
	Copyright (c) 1990 by Apple Computer, Inc.
	All Rights Reserved.

	This file contains the code to set up and handle
	the menus used in the network aware sample program.
*/

#include <IntMath.h>						/* {CIIGSIncludes}IntMath.h */
#include <Window.h>							/* {CIIGSIncludes}Window.h */
#include <Menu.h>							/* {CIIGSIncludes}Menu.h */
#include <Desk.h>							/* {CIIGSIncludes}Desk.h */
#include "Aware.h"

/* Declare the global variables so we can use them in these routines */
extern int quitFlag;
extern WmTaskRec event;
extern char asciiTime[];



/*
	setupMenus()
	
	This routine creates the system menu bar, complete with
	desk accessories, and draws it.
*/
void setupMenus()
{
	/* Create the system menu bar from a resource */
	SetSysBar(NewMenuBar2(refIsResource, 0x0001L, NULL));
	SetMenuBar(NULL);						/* Current menu bar is system menu bar */
	
	FixAppleMenu(AppleMenuID);				/* Add DAs to apple menu. */

	FixMenuBar();							/* Set sizes of menus. */
	
	DrawMenuBar();							/* Put the menu bar up */
}



/*
	doQuitItem()

	Handles the Quit menu item by setting the flag to quit and
	saving configuration data.
*/
void doQuitItem()
{
	saveConfig();							/* Save configuration data on exit */
	quitFlag++;								/* Let us leave the event loop */
}



/*
	doAboutItem
	
	Handles the "About Aware..." menu item.  It uses AlertWindow to
	put up a dialog box with one button (labelled Continue).  It also
	has one substitution string used for making the date/time (the
	configuration data) part of the message.
*/
void doAboutItem()
{
	char *substr[10];		/* Array of pointers to substitution strings */
	
	substr[0] = asciiTime;					/* First string is asciiTime */
	AlertWindow(refIsResource * 2, substr, 1L);
}



/*
	doMenu()
	
	This routine is called when a menu item is selected.  It determines
	which item was picked and then calls the apropriate routine to
	handle that item.
*/
void doMenu()
{
	unsigned int	menuNum, itemNum;

	menuNum = HiWord (event.wmTaskData);	/* Find out which menu was selected */
	itemNum = LoWord (event.wmTaskData);	/* Find out which item was selected */
	
	switch(itemNum) {
		case AboutItem:						/* "About Aware..." was picked */
			doAboutItem();					/* Handle the About item */
			break;
		case QuitItem:						/* Quit was picked */
			doQuitItem();					/* Handle Quit item */
			break;
		case LoadConfigItem:				/* "Load Configuration" picked */
			loadConfig();					/* handle it */
			break;
		case SaveConfigItem:				/* "Save Configuration" picked */
			saveConfig();					/* handle it */
			break;
        case UndoItem:						/* Handled by taskmaster */
        case CutItem:						/* Handled by taskmaster */
        case CopyItem:						/* Handled by taskmaster */
        case PasteItem:						/* Handled by taskmaster */
        case ClearItem:						/* Handled by taskmaster */
			break;
	}

	HiliteMenu(0, menuNum); 				/* Unhighlight the menu title. */
}
